/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import io.gitlab.jfronny.commons.impl.SerializerHolder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public interface Serializer {
    public static Serializer getInstance() {
        return SerializerHolder.getInstance();
    }

    public static void setInstance(Serializer instance) {
        SerializerHolder.setInstance(instance);
    }

    public String serialize(Object var1) throws IOException;

    default public void serialize(Object object, Appendable writer) throws IOException {
        writer.append(this.serialize(object));
    }

    default public <T> T deserialize(Reader source, Class<T> typeOfT) throws IOException {
        return this.deserialize(source, (Type)typeOfT);
    }

    public <T> T deserialize(Reader var1, Type var2) throws IOException;

    default public <T> T deserialize(String source, Class<T> typeOfT) throws IOException {
        return this.deserialize(source, (Type)typeOfT);
    }

    public <T> T deserialize(String var1, Type var2) throws IOException;

    public String getFormatMime();

    public static class SerializeException
    extends IOException {
        public SerializeException(String message) {
            super(message);
        }

        public SerializeException(String message, Throwable cause) {
            super(message, cause);
        }

        public SerializeException(Throwable cause) {
            super(cause);
        }
    }
}

